% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deleteTimeSeries.R
\name{deleteTimeSeries}
\alias{deleteTimeSeries}
\title{Delete Time Series from the database}
\usage{
deleteTimeSeries(series, con, chunksize = 10000,
  tbl_main = "timeseries_main", schema = "timeseries")
}
\arguments{
\item{series}{character name of the timeseries}

\item{con}{a PostgreSQL connection object}

\item{chunksize}{integer max size of chunk when deleting chunkwise. Defaults 
to 10000.}

\item{tbl_main}{character name of the table that contains the 
main time series catalog. Defaults to 'timeseries_main'.}

\item{schema}{SQL schema name. Defaults to 'timeseries'.}
}
\description{
This function deletes time series AND their metainformation from the 
database. All meta information in all series will be deleted. 
To only edit the original time series use \code{\link{storeTimeSeries}}
to overwrite existing series.
}
