% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vec-box_cox.R
\name{box_cox_vec}
\alias{box_cox_vec}
\alias{box_cox_inv_vec}
\alias{auto_lambda}
\title{Box Cox Transformation}
\usage{
box_cox_vec(x, lambda = "auto", silent = FALSE)

box_cox_inv_vec(x, lambda)

auto_lambda(
  x,
  method = c("guerrero", "loglik"),
  lambda_lower = -1,
  lambda_upper = 2
)
}
\arguments{
\item{x}{A numeric vector.}

\item{lambda}{The box cox transformation parameter.
If set to "auto", performs automated lambda selection using \code{auto_lambda()}.}

\item{silent}{Whether or not to report the automated \code{lambda} selection as a message.}

\item{method}{The method used for automatic \code{lambda} selection.
Either "guerrero" or "loglik".}

\item{lambda_lower}{A lower limit for automatic \code{lambda} selection}

\item{lambda_upper}{An upper limit for automatic \code{lambda} selection}
}
\description{
This is mainly a wrapper for the BoxCox transformation from the \code{forecast}
R package. The \code{box_cox_vec()} function performs the transformation.
The \code{box_cox_inv_vec()} inverts the transformation.
The \code{auto_lambda()} helps in selecting the optimal \code{lambda} value.
}
\details{
The Box Cox transformation is a power transformation that is commonly
used to reduce variance of a time series.

\strong{Automatic Lambda Selection}

If desired, the \code{lambda} argument can be selected using \code{auto_lambda()},
a wrapper for the Forecast R Package's \code{forecast::BoxCox.lambda()} function.
Use either of 2 methods:
\enumerate{
\item "guerrero" - Minimizes the non-seasonal variance
\item "loglik" - Maximizes the log-likelihood of a linear model fit to \code{x}
}
}
\examples{
library(dplyr)
library(timetk)

d10_daily <- m4_daily \%>\% filter(id == "D10")

# --- VECTOR ----

value_bc <- box_cox_vec(d10_daily$value)
value    <- box_cox_inv_vec(value_bc, lambda = 1.25119350454964)

# --- MUTATE ----

m4_daily \%>\%
    group_by(id) \%>\%
    mutate(value_bc = box_cox_vec(value))

}
\references{
\itemize{
\item \href{https://github.com/robjhyndman/forecast}{Forecast R Package}
\item \href{https://otexts.com/fpp2/transformations.html}{Forecasting: Principles & Practices: Transformations & Adjustments}
\item Guerrero, V.M. (1993) Time-series analysis supported by power transformations. \emph{Journal of Forecasting}, 12,  37--48.
}
}
\seealso{
\itemize{
\item Box Cox Transformation: \code{\link[=box_cox_vec]{box_cox_vec()}}
\item Lag Transformation: \code{\link[=lag_vec]{lag_vec()}}
\item Differencing Transformation: \code{\link[=diff_vec]{diff_vec()}}
\item Rolling Window Transformation: \code{\link[=slidify_vec]{slidify_vec()}}
\item Loess Smoothing Transformation: \code{\link[=smooth_vec]{smooth_vec()}}
\item Fourier Series: \code{\link[=fourier_vec]{fourier_vec()}}
\item Missing Value Imputation for Time Series: \code{\link[=ts_impute_vec]{ts_impute_vec()}}, \code{\link[=ts_clean_vec]{ts_clean_vec()}}
}

Other common transformations to reduce variance: \code{log()}, \code{log1p()} and \code{sqrt()}
}
