% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vec-log_interval.R
\name{log_interval_vec}
\alias{log_interval_vec}
\alias{log_interval_inv_vec}
\title{Log-Interval Transformation for Constrained Interval Forecasting}
\usage{
log_interval_vec(
  x,
  limit_lower = "auto",
  limit_upper = "auto",
  offset = 0,
  silent = FALSE
)

log_interval_inv_vec(x, limit_lower, limit_upper, offset = 0)
}
\arguments{
\item{x}{A positive numeric vector.}

\item{limit_lower}{A lower limit. Must be less than the minimum value.
If set to "auto", selects zero.}

\item{limit_upper}{An upper limit. Must be greater than the maximum value.
If set to "auto",  selects a value that is 10\% greater than the maximum value.}

\item{offset}{An offset to include in the log transformation.
Useful when the data contains values less than or equal to zero.}

\item{silent}{Whether or not to report the parameter selections as a message.}
}
\value{
A \code{numeric} vector of the transformed series.
}
\description{
The \code{log_interval_vec()} transformation constrains a forecast to an interval
specified by an \code{upper_limit} and a \code{lower_limit}. The transformation provides
similar benefits to \code{log()} transformation, while ensuring the inverted transformation
stays within an upper and lower limit.
}
\details{
\strong{Log Interval Transformation}

The Log Interval Transformation constrains values to specified upper and lower limits.
The transformation maps limits to a function:

\code{log(((x + offset) - a)/(b - (x + offset)))}

where \code{a} is the lower limit and \code{b} is the upper limit

\strong{Inverse Transformation}

The inverse transformation:

\code{(b-a)*(exp(x)) / (1 + exp(x)) + a - offset}
}
\examples{
library(dplyr)
library(timetk)

values_trans <- log_interval_vec(1:10, limit_lower = 0, limit_upper = 11)
values_trans

values_trans_forecast <- c(values_trans, 3.4, 4.4, 5.4)

values_trans_forecast \%>\%
    log_interval_inv_vec(limit_lower = 0, limit_upper = 11) \%>\%
    plot()


}
\references{
\itemize{
\item \href{https://otexts.com/fpp2/limits.html}{Forecasting: Principles & Practices: Forecasts constrained to an interval}
}
}
\seealso{
\itemize{
\item Box Cox Transformation: \code{\link[=box_cox_vec]{box_cox_vec()}}
\item Lag Transformation: \code{\link[=lag_vec]{lag_vec()}}
\item Differencing Transformation: \code{\link[=diff_vec]{diff_vec()}}
\item Rolling Window Transformation: \code{\link[=slidify_vec]{slidify_vec()}}
\item Loess Smoothing Transformation: \code{\link[=smooth_vec]{smooth_vec()}}
\item Fourier Series: \code{\link[=fourier_vec]{fourier_vec()}}
\item Missing Value Imputation & Anomaly Cleaning for Time Series: \code{\link[=ts_impute_vec]{ts_impute_vec()}}, \code{\link[=ts_clean_vec]{ts_clean_vec()}}
}

Other common transformations to reduce variance: \code{log()}, \code{log1p()} and \code{sqrt()}
}
