% Generated by roxygen2 (4.0.2): do not edit by hand
\name{timmaCategoryWeighted1}
\alias{timmaCategoryWeighted1}
\title{Predicting drug sensitivity with multi-class drug-target interaction data using two.sided and weighted TIMMA model}
\usage{
timmaCategoryWeighted1(profile_data, sens, loo = TRUE, class)
}
\arguments{
\item{profile_data}{the drug-target interaction data. See \code{\link{timma}}.}

\item{sens}{a drug sensitivity vector.}

\item{loo}{a logical value indicating whether to use the leave-one-out cross-validation in the model
selection process. By default, loo = TRUE.}

\item{class}{the number of classes in the drug-target interaction data}
}
\value{
A list containing the following components:
\item{dummy}{the predicted efficacy for target combinations that can be found from the training data}
\item{error}{the prediction errors}
\item{prediction}{predicted drug sensitivity}
}
\description{
A function to predict the drug sensitivity with multi-class drug-target interaction data using the
two.sided and weighted TIMMA model
}
\examples{
\dontrun{
profile<-data(tyner_interaction_multiclass)
sensitivity<-data(tyner_sensitivity)
results<-timmaCategoryWeighted1(profile[, 1:6], sensitivity[,1], class = 6)
}
}
\author{
Liye He \email{liye.he@helsinki.fi}
}

