% Generated by roxygen2 (4.0.2): do not edit by hand
\name{timmaModel}
\alias{timmaModel}
\title{Predicting drug sensitivity with binary drug-target interaction data}
\usage{
timmaModel(drug_target_profile, sens, loo = TRUE)
}
\arguments{
\item{drug_target_profile}{the drug-target interaction data. See \code{\link{timma}}.}

\item{sens}{a drug sensitivity vector.}

\item{loo}{a logical value indicating whether to use the leave-one-out cross-validation in the model
selection process. By default, loo = TRUE.}
}
\value{
A list containing the following components:
\item{dummy}{the predicted efficacy matrix}
\item{error}{the prediction errors}
\item{prediction}{predicted drug sensitivity}
The difference between \code{\link{timmaModel}} and \code{\link{timmaBinary}} is \code{\link{timmaModel}}
returns the predicted efficacy matrix of all possible target combinations while \code{\link{timmaBinary}}
not.
}
\description{
A function to predict the drug sensitivity with binary drug-target interaction data using the
one.sided TIMMA model
}
\examples{
data(tyner_interaction_binary)
data(tyner_sensitivity)
results<-timmaModel(tyner_interaction_binary[, 1:6], tyner_sensitivity[,1])
}
\author{
Liye He \email{liye.he@helsinki.fi}
}
\references{
Tang J, Karhinen L, Xu T, Szwajda A, Yadav B, Wennerberg K, Aittokallio T.
Target inhibition networks: predicting selective combinations of druggable targets to block cancer
survival pathways. PLOS Computational Biology 2013; 9: e1003226.
}

