% Generated by roxygen2 (4.0.2): do not edit by hand
\name{searchSpace}
\alias{searchSpace}
\title{Generate search space}
\usage{
searchSpace(drug_number, k_set, profile_data, y_actual)
}
\arguments{
\item{drug_number}{an integer to specify the number of drugs}

\item{k_set}{a vector to specify the selected target set}

\item{profile_data}{drug-target interaction data}

\item{y_actual}{the drug sensitivity data}
}
\value{
a list of the following components:
\item{IM_d}{search space of identical sets}
\item{IM_superset}{search space of supersets}
\item{IM_subset}{search space of subsets}
}
\description{
A function to generate the search space for sffs
}
\examples{
data(tyner_interaction_binary)
data(tyner_sensitivity)
num<-length(tyner_sensitivity[,1])
k_set<-rep(0, dim(tyner_interaction_binary)[2])
k_set[1]<-1
space<-searchSpace(num, k_set, tyner_interaction_binary, tyner_sensitivity[,1])
}
\author{
Liye He \email{liye.he@helsinki.fi}
}

