% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/html.R, R/pdf.R, R/utils.R
\name{tintHtml}
\alias{tintHtml}
\alias{tint}
\alias{tintPdf}
\alias{tintBook}
\alias{newthought}
\alias{margin_note}
\alias{quote_footer}
\alias{sans_serif}
\title{Tint Is Not Tufte -- A Tufte-Inspired HTML Format}
\usage{
tintHtml(...)

tint(...)

tintPdf(fig_width = 4, fig_height = 2.5, fig_crop = TRUE,
  dev = "pdf", highlight = "tango", citation_package = "natbib",
  latex_engine = "pdflatex", ...)

tintBook(fig_width = 4, fig_height = 2.5, fig_crop = TRUE,
  dev = "pdf", highlight = "tango", citation_package = "natbib",
  latex_engine = "pdflatex", ...)

newthought(text)

margin_note(text, icon = "&#8853;")

quote_footer(text)

sans_serif(text)
}
\arguments{
\item{...}{Other arguments to be passed to
\code{\link{pdf_document}} or \code{\link{html_document}}

\strong{Note:} For \code{tintPdf} and \code{tintBook}, you can
specify a custom \code{template} argument to replace the default.
You \emph{cannot} use the \code{theme} argument in \code{tintHHtml()}
because this argument has been set internally.}

\item{fig_width}{Default width (in inches) for figures}

\item{fig_height}{Default height (in inches) for figures}

\item{fig_crop}{\code{TRUE} to automatically apply the \code{pdfcrop} utility
(if available) to pdf figures}

\item{dev}{Graphics device to use for figure output (defaults to pdf)}

\item{highlight}{Syntax highlighting style. Supported styles include
"default", "tango", "pygments", "kate", "monochrome", "espresso",
"zenburn", and "haddock". Pass \code{NULL} to prevent syntax highlighting.}

\item{citation_package}{The LaTeX package to process citations, \code{natbib}
or \code{biblatex}. Use \code{none} if neither package is to be used.}

\item{latex_engine}{LaTeX engine for producing PDF output. Options are
"pdflatex", "lualatex", and "xelatex".}

\item{text}{A character string to be presented as a \dQuote{new thought}
(using small caps), or a margin note, or a footer of a quote}

\item{icon}{A character string to indicate there is a hidden margin note when
the page width is too narrow (by default it is a circled plus sign)}
}
\description{
A template for creating html reports according to the style of
Edward R. Tufte and Richard Feynman, but with an updated font
choice. The three key functions \code{tintHtml}, \code{tintPdf}
and \code{tintBook} offer, respectively, support for html and
pdf-based shorter (\dQuote{article-length} writeups as well as
support for longer pdf-based content.
}
\details{
\code{tintHtml} provides the HTML format based on the Tufte CSS
  \url{https://edwardtufte.github.io/tufte-css/} with fonts set according to
\url{https://github.com/nogginfuel/envisioned-css}.
\code{tintPdf} provides a similar PDF format using the same font family and
styling applied to the Tufte-LaTeX
\url{https://tufte-latex.github.io/tufte-latex/} class.
\code{tintBook} is a (still somewhat experimental) pdf book variant.

\code{newthought()} can be used in inline R expressions in R
  Markdown (e.g. \samp{`r newthought(Some text)`}), and it works for both
  HTML (\samp{<span class="newthought">text</span>}) and PDF
  (\samp{\\newthought{text}}) output.

\code{margin_note()} can be used in inline R expressions to write a
  margin note (like a sidenote but not numbered).

\code{quote_footer()} formats text as the footer of a quote. It puts
  \code{text} in \samp{<footer></footer>} for HTML output, and
  after \samp{\\hfill} for LaTeX output (to right-align text).

\code{sans_serif()} applies sans-serif fonts to \code{text}.
}
\references{
See \url{https://rstudio.github.io/tufte/} for the
\pkg{tufte} package this was initially derived from. See
\url{https://eddelbuettel.github.io/tint/} for usage examples
from this package.
}
\seealso{
\link{Custom-templates}, \link{YAML-metadata}.
}
