% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/5_get_deg_all.R
\name{get_deg_all}
\alias{get_deg_all}
\title{get_deg_all}
\usage{
get_deg_all(
  exp,
  group_list,
  ids,
  pkg = 4,
  color_volcano = c("#2874C5", "grey", "#f87669"),
  my_genes = NULL,
  show_rownames = FALSE,
  entriz = TRUE,
  ...
)
}
\arguments{
\item{exp}{A numeric matrix}

\item{group_list}{A factor with duplicated character or factor}

\item{ids}{a data.frame with 2 columns,including probe_id and symbol}

\item{pkg}{a integer ,means which Differential analysis packages you used,we support three packages by now, 1,2,3,4 respectively means "DESeq2","edgeR","limma(voom)","limma"}

\item{color_volcano}{color for volcano plot}

\item{my_genes}{genes for pheatmap}

\item{show_rownames}{logical,show rownames or not}

\item{entriz}{logical , if TRUE ,convert symbol to entriz id.}

\item{...}{other parameters from get_deg}
}
\value{
a list with deg data.frame, volcano plot ,pca plot ,heatmap and a list with DEGs.
}
\description{
do diffiencial analysis according to exprission set and group information
}
\examples{
\donttest{
gse = "GSE42872"
geo = geo_download(gse,destdir=tempdir())
group_list = rep(c("A","B"),each = 3)
group_list = factor(group_list)
find_anno(geo$gpl)
ids <- AnnoProbe::idmap(geo$gpl,destdir = tempdir())
dcp = get_deg_all(geo$exp,group_list,ids)
head(dcp$deg)
dcp$plots
}
}
\seealso{
\code{\link{get_deg}};\code{\link{multi_deg_all}}
}
\author{
Xiaojie Sun
}
