% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scholar_search.R
\name{scholar_search}
\alias{scholar_search}
\title{Search Google Scholar Highly Related Papers or Author}
\usage{
scholar_search(
  keyword,
  is_author = TRUE,
  server_url = "https://api.scaleserp.com",
  server_key = NULL
)
}
\arguments{
\item{keyword}{A keyword, can be author name, e.g. "Shixiang Wang".}

\item{is_author}{Default is \code{TRUE}, find author information, if \code{FALSE}, return the first page result in search engine.}

\item{server_url}{Server URL, here I use \href{https://www.scaleserp.com/google-scholar-api}{Scale SERP API}.}

\item{server_key}{Key for searching data, you can obtain it from URL above. If not set, use personal key from Shixiang.
Total 125 free searches per month.}
}
\value{
A \code{data.frame} or a \code{list}.
}
\description{
Search Google Scholar Highly Related Papers or Author
}
\examples{
\donttest{
x <- scholar_search("Shixiang Wang")
x
x <- scholar_search("Shixiang Wang", is_author = FALSE)
if (!is.null(x)) {
  x$gt
}
}
}
