% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tipitaka-docs.R
\docType{data}
\name{vinaya_pitaka}
\alias{vinaya_pitaka}
\title{All the books of the Vinaya Pitaka}
\format{
A tibble with the variables:
\describe{
  \item{book}{Abbreviated title}
  \item{name}{Full title}
}
}
\usage{
vinaya_pitaka
}
\description{
A subset of tipitaka_names consisting of only the books of
the Vinaya Pitaka. These are easier to read if you call
\code{stringi::stri_unescape_unicode} first.
}
\examples{
# Clean up the Unicode characters to make things more readble:
vinaya_pitaka$name <-
  stringi::stri_unescape_unicode(vinaya_pitaka$name)

# Count all the words in the Vinaya Pitaka:
sum(tipitaka_long[tipitaka_long$book \%in\% vinaya_pitaka$book, "n"])

}
\keyword{datasets}
