% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoothing.R
\name{smoothing}
\alias{smoothing}
\title{Variance Smoothing and Effective Sample Sizes Estimation}
\usage{
smoothing(
  data,
  direct_estimates,
  area_id = NULL,
  raw_variance = NULL,
  areas_sample_sizes = NULL,
  additional_covariates = NULL,
  method = c("ols", "gls", "kish"),
  var_function = NULL,
  survey_data = NULL,
  survey_area_id = NULL,
  weights = NULL,
  sizes = NULL
)
}
\arguments{
\item{data}{A \code{data.frame} object including the direct estimates.}

\item{direct_estimates}{Character string specifying the variable in \code{data} denoting the direct estimates.}

\item{area_id}{Character string indicating the variable with domain names included in \code{data}, to be specified if method \code{"kish"} is selected.}

\item{raw_variance}{Character string indicating the variable name for raw variance estimates included in \code{data} object, to be specified if methods \code{"ols"} or \code{"gls"} are selected.}

\item{areas_sample_sizes}{Character string indicating the variable name for domain sample sizes included in \code{data} object, to be specified if methods \code{"ols"} or \code{"gls"} are selected.}

\item{additional_covariates}{A vector of character strings indicating the variable names of possible additional covariates, included in \code{data}, to be added to the smoothing procedure if methods \code{"ols"} or \code{"gls"} are selected.}

\item{method}{The method to be used. The choices are \code{"kish"},\code{"ols"} and \code{"gls"}.}

\item{var_function}{An object of class \code{function} denoting the variance function of the response variable. The default option (\code{NULL}) matches the proportion case being equal to \code{function(x) x * (1 - x)}.}

\item{survey_data}{An additional dataset to be specified when method \code{"kish"} is selected, defined at sampling unit level (e.g., households) and comprising sampling weights, unit sizes and domain names.}

\item{survey_area_id}{Character string indicating the variable denoting the domain names included in the \code{survey_data} object.}

\item{weights}{Character string indicating the variable including sampling weights in \code{survey_data} object.}

\item{sizes}{Character string indicating the variable including unit sizes in \code{survey_data} object.}
}
\value{
An object of class \code{smoothing_fitsae}, being a list of vectors including dispersion parameters estimates: both the variances and the effective sample sizes. When \code{"ols"} or \code{"gls"} method has been selected, the list incorporates also an object of class \code{\link[nlme]{gls}} from \code{nlme} package.
}
\description{
The \code{smoothing()} function implements three methods, all yielding refined estimates of either variance or effective sample size, to account for indicators with different variance functions. The output estimates are ready to be used as known parameters in an area-level model, and they need to be added to the analysed \code{data.frame} object. All the implemented methods enable the estimation of the effective sample sizes, whereas \code{"ols"} and \code{"gls"} also perform a variance smoothing procedure.
}
\examples{

library(tipsae)

# loading toy dataset
data("emilia_cs")

# perform smoothing procedure
smoo <- smoothing(emilia_cs, direct_estimates = "hcr", area_id = "id",
                  raw_variance = "vars", areas_sample_sizes = "n",
                  var_function = NULL, method = "ols")

}
\references{
\insertRef{kish1992weighting}{tipsae}

\insertRef{fabrizi2011hierarchical}{tipsae}
}
\seealso{
\code{\link[nlme]{gls}} for details on estimation procedure for \code{"ols"} and \code{"gls"} methods.
}
