% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_method_01_kRp.corpus-class_readability.R
\docType{methods}
\name{readability,kRp.corpus-method}
\alias{readability,kRp.corpus-method}
\title{Apply readability() to all texts in kRp.corpus objects}
\usage{
\S4method{readability}{kRp.corpus}(
  txt.file,
  summary = TRUE,
  mc.cores = getOption("mc.cores", 1L),
  quiet = TRUE,
  ...
)
}
\arguments{
\item{txt.file}{An object of class \code{\link[tm.plugin.koRpus:kRp.corpus-class]{kRp.corpus}}.}

\item{summary}{Logical, determines if the \code{summary} slot should automatically be
updated by calling \code{\link[tm.plugin.koRpus:summary]{summary}} on the result.}

\item{mc.cores}{The number of cores to use for parallelization,
      see \code{\link[parallel:mclapply]{mclapply}}.}

\item{quiet}{Logical,
      if \code{FALSE} shows a status bar for some calculations of each text, see
\code{\link[koRpus:readability]{readability}} for details.}

\item{...}{options to pass through to \code{\link[koRpus:readability]{readability}}.}
}
\value{
An object of the same class as \code{txt.file}.
}
\description{
This method calls \code{\link[koRpus:readability]{readability}} on all tagged text objects
inside the given \code{txt.file} object (using \code{mclapply}).
}
\examples{
# use readCorpus() to create an object of class kRp.corpus
# code is only run when the english language package can be loaded
if(require("koRpus.lang.en", quietly = TRUE)){
  myCorpus <- readCorpus(
    dir=file.path(path.package("tm.plugin.koRpus"), "examples", "corpus"),
    hierarchy=list(
      Topic=c(
        Winner="Reality Winner",
        Edwards="Natalie Edwards"
      ),
      Source=c(
        Wikipedia_prev="Wikipedia (old)",
        Wikipedia_new="Wikipedia (new)"
      )
    ),
    # use tokenize() so examples run without a TreeTagger installation
    tagger="tokenize",
    lang="en"
  )

  myTexts <- readability(myCorpus)
  corpusSummary(myCorpus)
} else {}
}
