% Generated by roxygen2 (4.0.1): do not edit by hand
\name{tm_facets}
\alias{tm_facets}
\title{Small multiples grid}
\usage{
tm_facets(by = NULL, ncol = NULL, nrow = NULL,
  free.scales = is.null(by), free.scales.fill = free.scales,
  free.scales.bubble.size = free.scales,
  free.scales.bubble.col = free.scales, free.scales.line.col = free.scales,
  free.scales.line.lwd = free.scales)
}
\arguments{
\item{by}{data variable name by which the data is split}

\item{ncol}{number of columns of the small multiples grid}

\item{nrow}{number of rows of the small multiples grid}

\item{free.scales}{logical. Should all scales of the plotted data variables be free, i.e. independent of each other? Possible data variables are color from \code{\link{tm_fill}}, color and size from \code{\link{tm_bubbles}} and line color from \code{\link{tm_lines}}.}

\item{free.scales.fill}{logical. Should the color scale for the choropleth be free?}

\item{free.scales.bubble.size}{logical. Should the bubble size scale for the bubble map be free?}

\item{free.scales.bubble.col}{logical. Should the color scale for the bubble map be free?}

\item{free.scales.line.col}{Should the line color scale be free?}

\item{free.scales.line.lwd}{Should the line width scale be free?}
}
\value{
\code{\link{tmap-element}}
}
\description{
This element specifies how small multiples are placed in a grid. Either the argument \code{by} should be specified, i.e. the name of a variable by which the data is grouped, or multiple variable names sould be provided with \code{\link{tm_fill}}, \code{\link{tm_lines}}, or \code{\link{tm_bubbles}}. In this function, the number of rows and columns can be specified, as well as whether the scales are free (i.e. independent of each other).
}
\examples{
## World example
data(World)
tm_shape(World) +
    tm_fill(c("green", "blue")) +
tm_layout_World(c("A green world", "A blue world"))

## Europe example
data(Europe)
tm_shape(Europe) +
    tm_fill(c("gdp_cap_est", "pop_est_dens"), style="kmeans") +
tm_layout_Europe(c("GDP per capita", "Population density"), scale=2)



## Netherlands example
data(NLD_muni)
data(NLD_prov)

tm_shape(NLD_muni) +
    tm_fill(c("pop_0_14", "pop_15_24", "pop_25_44", "pop_45_64", "pop_65plus"),
            convert2density=TRUE, style="kmeans") +
tm_shape(NLD_prov) +
    tm_borders() +
    tm_facets(free.scales=FALSE) +
tm_layout_NLD(c("Population 0 to 14", "Population 15 to 24", "Population 25 to 44", 
    "Population 45 to 64", "Population 65 and older"), scale=4, draw.frame = TRUE)
}
\seealso{
\href{../doc/tmap-nutshell.html}{\code{vignette("tmap-nutshell")}}
}

