% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkg.R
\docType{package}
\name{tmap-package}
\alias{tmap}
\alias{tmap-package}
\title{Thematic Map Visualization}
\description{
Thematic maps are geographical maps in which spatial data distributions are visualized. This package offers a flexible, layer-based, and easy to use approach to create thematic maps, such as choropleths and bubble maps. It is based on the grammar of graphics, and resembles the syntax of ggplot2.
}
\details{
This page provides a brief overview of all package functions. See \href{../doc/tmap-nutshell.html}{\code{vignette("tmap-nutshell")}} for a short introduction with examples. See \href{../doc/tmap-modes.html}{\code{vignette("tmap-modes")}} for a short demo of the two output modes: plot and interactive view.
}
\section{Quick plotting method}{

\tabular{ll}{
\code{\link{qtm}}\tab To plot a thematic map \cr
--------------------------- \tab --------------------------------------------------------------------------------------------------- \cr
}
}

\section{Main plotting method}{

Shape specification:
\tabular{ll}{
\code{\link{tm_shape}}\tab To specify a shape object \cr
--------------------------- \tab --------------------------------------------------------------------------------------------------- \cr
}

Aesthetics base layers:
\tabular{ll}{
\code{\link{tm_polygons}}\tab To create a polygon layer (with borders) \cr
\code{\link{tm_symbols}}\tab To create a layer of symbols \cr
\code{\link{tm_lines}}\tab To create a layer of lines \cr
\code{\link{tm_raster}}\tab To create a raster layer \cr
\code{\link{tm_text}}\tab To create a layer of text labels \cr
}

Aesthetics derived layers:
\tabular{ll}{
\code{\link{tm_fill}}\tab To create a polygon layer (without borders) \cr
\code{\link{tm_borders}}\tab To create polygon borders \cr
\code{\link{tm_bubbles}}\tab To create a layer of bubbles \cr
\code{\link{tm_squares}}\tab To create a layer of squares \cr
\code{\link{tm_dots}}\tab To create a layer of dots \cr
\code{\link{tm_markers}}\tab To create a layer of markers \cr
\code{\link{tm_iso}}\tab To create a iso/contour lines \cr
--------------------------- \tab --------------------------------------------------------------------------------------------------- \cr
}

Facetting (small multiples)
\tabular{ll}{
\code{\link{tm_facets}}\tab To define facets \cr
--------------------------- \tab --------------------------------------------------------------------------------------------------- \cr
}

Attributes:
\tabular{ll}{
\code{\link{tm_grid}}\tab To create grid lines \cr
\code{\link{tm_scale_bar}}\tab To create a scale bar \cr
\code{\link{tm_compass}}\tab To create a map compass \cr
\code{\link{tm_credits}}\tab To create a text for credits \cr
\code{\link{tm_logo}}\tab To create a logo \cr
\code{\link{tm_xlab} and \link{tm_ylab}}\tab To create axis labels \cr
--------------------------- \tab --------------------------------------------------------------------------------------------------- \cr
}

Layout element:
\tabular{ll}{
\code{\link{tm_layout}}\tab To adjust the layout (main function)\cr
\code{\link{tm_legend}}\tab Shortcut to adjust the legend \cr
\code{\link{tm_view}}\tab Options for the interactive view mode \cr
--------------------------- \tab --------------------------------------------------------------------------------------------------- \cr
}

Change options:
\tabular{ll}{
\code{\link{tmap_mode}}\tab To set the tmap mode: \code{"plot"} or \code{"view"}\cr
\code{\link{ttm}}\tab To toggle between the modes\cr
\code{\link{tmap_style}}\tab To set the default style \cr
--------------------------- \tab --------------------------------------------------------------------------------------------------- \cr
}

Create icons:
\tabular{ll}{
\code{\link{tmap_icons}}\tab To specify icons for markers or proportional symbols \cr
--------------------------- \tab --------------------------------------------------------------------------------------------------- \cr
}
}

\section{Output functions}{
 
\tabular{ll}{
\code{\link{print}}\tab Plot in graphics device or view interactively in web browser or RStudio's viewer pane \cr
\code{\link{last_map}}\tab Redraw the last map \cr
\code{\link{tmap_leaflet}}\tab Obtain a leaflet widget object \cr
\code{\link{animation_tmap}}\tab Create an animation \cr
\code{\link{save_tmap}}\tab To save thematic maps (both in plot and view mode) \cr
--------------------------- \tab --------------------------------------------------------------------------------------------------- \cr
}
}

\section{Spatial datasets}{
 
\tabular{ll}{
\code{\link{World}}\tab World country data (spatial polygons) \cr
\code{\link{Europe}}\tab European country data (spatial polygons) \cr
\code{\link{NLD_prov}}\tab Netherlands province data (spatial polygons) \cr
\code{\link{NLD_muni}}\tab Netherlands municipal data (spatial polygons) \cr
\code{\link{metro}}\tab Metropolitan araes (spatial points) \cr
\code{\link{rivers}}\tab Rivers (spatial lines) \cr
\code{\link{land}}\tab Global land cover (spatial grid)\cr
--------------------------- \tab --------------------------------------------------------------------------------------------------- \cr
}
}
\author{
Martijn Tennekes \email{mtennekes@gmail.com}
}
\seealso{
\href{../doc/tmap-nutshell.html}{\code{vignette("tmap-nutshell")}}

\href{../doc/tmap-modes.html}{\code{vignette("tmap-modes")}}
}
\keyword{GIS,}
\keyword{bubble}
\keyword{choropleth,}
\keyword{map}
\keyword{maps,}
\keyword{statistical}
\keyword{thematic}

