% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_tmhmm_on_sequence.R
\name{run_tmhmm_on_sequence}
\alias{run_tmhmm_on_sequence}
\title{Run TMHMM directy on a protein sequence}
\usage{
run_tmhmm_on_sequence(
  protein_sequence,
  folder_name = get_default_tmhmm_folder()
)
}
\arguments{
\item{protein_sequence}{a protein sequence, with
the amino acids as capitals, for
example `MEILCEDNTSLSSIPNSL`}

\item{folder_name}{superfolder of TMHMM.
The superfolder's name is \code{/home/[user_name]/.local/share}
by default, as can be obtained by
\link{get_default_tmhmm_folder}}
}
\value{
the topology. The topology is a character string
  with the same length as the
  protein sequence. The topology consists of the characters
  \code{i} ('inside'), \code{I} ('inside'),
  \code{m} ('membrane'), \code{M} ('membrane'),
  \code{o} ('outside') and \code{O} ('outside')
}
\description{
Run TMHMM directy on one protein sequence
}
\examples{
if (is_tmhmm_installed()) {
  protein_sequence <- paste0(
    "QEKNWSALLTAVVIILTIAGNILVIMAVSLEKKLQNATNYFLM",
    "SLAIADMLLGFLVMPVSMLTILYGYRWP"
  )
  run_tmhmm_on_sequence(protein_sequence)
}
}
