% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importexport.R
\name{makeTmodFromDataFrame}
\alias{makeTmodFromDataFrame}
\title{Convert a data frame to a tmod object}
\usage{
makeTmodFromDataFrame(
  df,
  feature_col = 1,
  module_col = 2,
  title_col = NULL,
  extra_module_cols = NULL,
  extra_gene_cols = NULL
)
}
\arguments{
\item{df}{A data frame}

\item{feature_col}{Which column contains the feature (gene) IDs}

\item{module_col}{Which column contains the module (gene set) IDs}

\item{title_col}{Description of the modules (if NULL, the description will
be taken from the module_col)}

\item{extra_module_cols}{Additional columns to include in the module data frame}

\item{extra_gene_cols}{Additional gene columns to include in the genes data frame}
}
\value{
A tmod object
}
\description{
Convert a data frame to a tmod object
}
\details{
`makeTmodFromFeatureDataFrame` converts mapping information from features (genes) to modules (gene
sets). The data frame has a row for each feature-module pair.

`makeTmodFromModuleDataFrame` converts mapping information from features
(genes) to modules (gene sets). The data frame has a row for each module,
and all gene IDs corresponding to a module are stored as a comma separated string, e.g.
       
Vice versa, `tmod2DataFrame` converts a tmod object to a data frame.
}
\examples{
df <- data.frame(
gene_id=LETTERS[1:10],
geneset_id=rep(letters[1:2], each=5),
geneset_description=rep(paste0("Gene set ", letters[1:2]), each=5))
res <- makeTmodFromDataFrame(df, 
  feature_col="gene_id", 
  module_col="geneset_id",
  title_col="geneset_description")
}
\seealso{
\code{\link{tmod-class}}, \code{\link{makeTmod}}
}
