# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Random Generation for Truncated Multivariate Normal 
#'
#' Draws from truncated multivariate normal distribution subject to 
#' linear inequality constraints represented by a matrix. 
#' 
#' @param mean \code{n x p} matrix of means. The number of rows is the number 
#'   of observations. The number of columns is the dimension of the problem.
#' @param sigma \code{p x p} covariance matrix. 
#' @param blc \code{m x p} matrix of coefficients for linear inequality 
#'   constraints.
#' @param lower \code{n x m} or \code{1 x m} matrix of lower bounds for 
#'   truncation. 
#' @param upper \code{n x m} or \code{1 x m} matrix of upper bounds for 
#'   truncation. 
#' @param init \code{n x p} or \code{1 x p} matrix of initial values.
#' @param burn Number of burn-in iterations. Defaults to 10.
#' 
#' @return Returns a \code{n x p} matrix of random numbers following the 
#'   specified truncated multivariate normal distribution. 
#'
#' @examples
#' # Example 1: full rank
#' d = 3;
#' rho = 0.9;
#' sigma = matrix(0, d, d);
#' sigma = rho^abs(row(sigma) - col(sigma));
#' blc = diag(1,d);
#' n = 1000;
#' mean = matrix(rep(1:d,n), nrow=n, ncol=d, byrow=TRUE);
#' lower = matrix(rep(-1,d), nrow=1);
#' upper = matrix(rep(1,d), nrow=1);
#' init = matrix(rep(0,d), nrow=1);
#' set.seed(1203)
#' result = rtmvnorm(mean, sigma, blc, lower, upper, init, burn=50)
#' apply(result, 2, summary)
#' 
#' # Example 2: non-full rank, invalid initial values
#' d = 3;
#' rho = 0.5;
#' sigma = matrix(0, d, d);
#' sigma = rho^abs(row(sigma) - col(sigma));
#' blc = matrix(c(1,1,1,0,1,0,1,0,1),ncol=d);
#' n = 100;
#' mean = matrix(rep(1:d,n), nrow=n, ncol=d, byrow=TRUE);
#' lower = matrix(rep(-1,d), nrow=1);
#' upper = matrix(rep(1,d), nrow=1);
#' init = matrix(rep(0.8,d), nrow=1);
#' set.seed(1228)
#' result = rtmvnorm(mean, sigma, blc, lower, upper, init, burn=50)
#' apply(result, 2, summary)
#' 
#' # Example 3: means, lower, or upper bounds differ across samples
#' d = 3;
#' rho = 0.5;
#' sigma = matrix(0, d, d);
#' sigma = rho^abs(row(sigma) - col(sigma));
#' blc = matrix(c(1,0,1,1,1,0),nrow=d-1,ncol=d,byrow=TRUE)
#' n = 100;
#' set.seed(3084)
#' mean = matrix(runif(n*d), nrow=n, ncol=d);
#' lower = matrix(rep(-1,d-1), nrow=1);
#' upper = matrix(rep(1,d-1), nrow=1);
#' init = matrix(rep(0.8,d), nrow=1);
#' result = rtmvnorm(mean, sigma, blc, lower, upper, init, burn=50)
#' apply(result, 2, summary)
#' 
#' @export
rtmvnorm <- function(mean, sigma, blc, lower, upper, init, burn = 10L) {
    .Call(`_tmvtnsim_rtmvnorm`, mean, sigma, blc, lower, upper, init, burn)
}

#' Random Generation for Truncated Multivariate t 
#'
#' Draws from truncated multivariate t distribution subject to 
#' linear inequality constraints represented by a matrix. 
#' 
#' @param mean \code{n x p} matrix of means. The number of rows is the number 
#'   of observations. The number of columns is the dimension of the problem.
#' @param sigma \code{p x p} covariance matrix. 
#' @param nu degrees of freedom for Student-t distribution.
#' @param blc \code{m x p} matrix of coefficients for linear inequality 
#'   constraints.
#' @param lower \code{n x m} or \code{1 x m} matrix of lower bounds for 
#'   truncation. 
#' @param upper \code{n x m} or \code{1 x m} matrix of upper bounds for 
#'   truncation. 
#' @param init \code{n x p} or \code{1 x p} matrix of initial values.
#' @param burn Number of burn-in iterations. Defaults to 10.
#' 
#' @return Returns a \code{n x p} matrix of random numbers following the 
#'   specified truncated multivariate t distribution. 
#'
#' @examples
#' # Example 1: full rank
#' d = 3;
#' rho = 0.5;
#' nu = 10;
#' sigma = matrix(0, d, d);
#' sigma = rho^abs(row(sigma) - col(sigma));
#' blc = diag(1,d);
#' n = 1000;
#' mean = matrix(rep(1:d,n), nrow=n, ncol=d, byrow=TRUE);
#' lower = matrix(rep(-1,d), nrow=1);
#' upper = matrix(rep(1,d), nrow=1);
#' init = matrix(rep(0.8,d), nrow=1);
#' set.seed(1203)
#' result = rtmvt(mean, sigma, nu, blc, lower, upper, init, burn=50)
#' apply(result, 2, summary)
#' 
#' # Example 2: non-full rank, different means
#' d = 3;
#' rho = 0.5;
#' sigma = matrix(0, d, d);
#' sigma = rho^abs(row(sigma) - col(sigma));
#' nu = 10;
#' blc = matrix(c(1,0,1,1,1,0),nrow=d-1,ncol=d,byrow=TRUE)
#' n = 100;
#' set.seed(3084)
#' mean = matrix(runif(n*d), nrow=n, ncol=d);
#' lower = matrix(rep(-1,d-1), nrow=1);
#' upper = matrix(rep(1,d-1), nrow=1);
#' init = matrix(rep(0.8,d), nrow=1);
#' result = rtmvt(mean, sigma, nu, blc, lower, upper, init, burn=50)
#' apply(result, 2, summary)
#'
#' @export
rtmvt <- function(mean, sigma, nu, blc, lower, upper, init, burn = 10L) {
    .Call(`_tmvtnsim_rtmvt`, mean, sigma, nu, blc, lower, upper, init, burn)
}

norm_rej <- function(a, b) {
    .Call(`_tmvtnsim_norm_rej`, a, b)
}

unif_rej <- function(a, b) {
    .Call(`_tmvtnsim_unif_rej`, a, b)
}

halfnorm_rej <- function(a, b) {
    .Call(`_tmvtnsim_halfnorm_rej`, a, b)
}

exp_rej <- function(a, b) {
    .Call(`_tmvtnsim_exp_rej`, a, b)
}

#' Random Generation for Truncated Univariate Normal 
#'
#' Draws from truncated univariate normal distribution within an interval.
#'  
#' @param mean Vector of means, whose length is the number of observations. 
#' @param sd Standard deviation. Defaults to 1.
#' @param lower A scalar of lower bound for truncation, or a vector of 
#'   lower bounds with the same length as \code{mean}. 
#' @param upper A scalar of upper bound for truncation, or a vector of 
#'   upper bounds with the same length as \code{mean}. 
#'
#' @return Returns a vector of random numbers following the specified 
#'   truncated univariate normal distribution. 
#'
#' @examples
#' set.seed(1203)
#' x = rtnorm(mean=rep(1,1000), sd=2, lower=-2, upper=3)
#' summary(x)
#'
#' @export
rtnorm <- function(mean, sd, lower, upper) {
    .Call(`_tmvtnsim_rtnorm`, mean, sd, lower, upper)
}

