% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid-selection.R
\name{grid_selection_row}
\alias{grid_selection_row}
\title{Row selection (in shiny)}
\usage{
grid_selection_row(
  grid,
  inputId,
  type = c("checkbox", "radio"),
  return = c("data", "index"),
  width = NULL
)
}
\arguments{
\item{grid}{A table created with \code{\link[=datagrid]{datagrid()}}.}

\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{type}{Type of selection: \code{"checkbox"} (multiple rows) or \code{"radio"} (unique row).}

\item{return}{Value that will be accessible via \code{input} :
a \code{data.frame} with selected row(s) or just the index of selected row(s).}

\item{width}{Width of the column.}
}
\value{
A \code{datagrid} htmlwidget.
}
\description{
Row selection (in shiny)
}
\examples{
library(shiny)
library(toastui)

ui <- fluidPage(
  tags$h2("datagrid row selection"),
  fluidRow(
    column(
      width = 6,
      datagridOutput("grid_checkbox"),
      verbatimTextOutput("res_checkbox")
    ),
    column(
      width = 6,
      datagridOutput("grid_radio"),
      verbatimTextOutput("res_radio")
    )
  )
)

server <- function(input, output, session) {

  df <- data.frame(
    index = 1:12,
    month = month.name,
    letters = letters[1:12]
  )

  output$grid_checkbox <- renderDatagrid({
    datagrid(df) \%>\%
      grid_selection_row(
        inputId = "sel_check",
        type = "checkbox"
      )
  })

  output$res_checkbox <- renderPrint({
    input$sel_check
  })

  output$grid_radio <- renderDatagrid({
    datagrid(df) \%>\%
      grid_selection_row(
        inputId = "sel_radio",
        type = "radio"
      )
  })

  output$res_radio <- renderPrint({
    input$sel_radio
  })

}

if (interactive())
  shinyApp(ui, server)
}
