% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tobit1.R
\name{tobit1}
\alias{tobit1}
\alias{nobs.tobit1}
\alias{vcov.tobit1}
\alias{logLik.tobit1}
\alias{summary.tobit1}
\alias{print.tobit1}
\alias{print.summary.tobit1}
\title{Truncated response model}
\usage{
tobit1(
  formula,
  data,
  subset = NULL,
  weights = NULL,
  start = NULL,
  left = 0,
  right = Inf,
  scedas = c("exp", "pnorm"),
  sample = c("censored", "truncated"),
  method = c("ml", "lm", "2steps", "trimmed", "nls"),
  trace = FALSE
)

\method{nobs}{tobit1}(object, ...)

\method{vcov}{tobit1}(object, ...)

\method{logLik}{tobit1}(object, ...)

\method{summary}{tobit1}(object, ...)

\method{print}{tobit1}(x, digits = max(3L, getOption("digits") - 3L), ...)

\method{print}{summary.tobit1}(
  x,
  digits = max(3, getOption("digits") - 2),
  width = getOption("width"),
  ...
)
}
\arguments{
\item{formula}{a symbolic description of the model; if two right
hand sides are provided, the second one is used to parametrize
the conditional variance,}

\item{data}{a data frame,}

\item{subset}{a subset,}

\item{weights}{an optional vector of weights (currently only
supported by ml method}

\item{start}{an optional vector of starting values}

\item{left, right}{left and right limits of the dependent
variable. The default is respectively 0 and +Inf which
corresponds to the most classic (left-zero truncated) tobit
model,}

\item{scedas}{the functional form used to specify the conditional
variance, which is of the form: s_n = s_o f(Z'g), where Z are
the covariates indicated in the second part of the formula and
z_o and g a set of parameters to estimate. Currently, f can
either be set to \code{"exp"} or \code{"pnorm"},}

\item{sample}{either \code{"censored"} (the default) to estimate the
censored (tobit) regression model or \code{"truncated"} to estimated
the truncated regression model,}

\item{method}{one of \code{"ml"} for maximum likelihood, \code{"lm"} for
(biased) least squares estimators and \code{"2steps"} for two-steps
consistent estimators, \code{"trimmed"} for symetrically censored
estimator,}

\item{trace}{a boolean (the default if \code{FALSE}) if \code{TRUE} some
information about the optimization process is printed,}

\item{...}{further arguments.}

\item{x, object}{an object of class \code{tobit1} or \code{summary.tobit1},}

\item{digits, width}{see \code{base::print},}
}
\value{
An object of class \code{c('tobit1', 'lm')}, which is a list containg the following components:
\itemize{
\item coefficients: a named vector of coefficients,
\item linear.predictor: the linear fit,
\item fitted.values: the fitted values,
\item residuals: the residuals,
\item df.residual: the residual degrees of freedom,
\item hessian: the hessian of the log-likelihood function at the optimum,
\item vcov: an estimator of the covariance matrix of the coefficients,
\item gradObs: a N x K matrix containing the individual contributions to the gradient,
\item logLik: the value of the log-likelihood at the optimum,
\item model: the model frame,
\item terms: the terms object used,
\item call: the matched call
\item xlevels: a record of the levels of the factors used in fitting
\item na.action: intormation returned by \code{model.frame} on the special handling of \code{NA}'s.
}
}
\description{
Estimation of models for which the response is truncated, either on
censored or truncated samples using linear models, maximum
likelihood or two-steps estimators
}
\examples{
# tobit model estimated by maximum likelihood
tobit1(fees ~ expense, feesadm)
# same using two-steps estimator
tobit1(fees ~ expense, feesadm, method = "2steps")
# same model fitted on the truncated sample
tobit1(fees ~ expense, feesadm, sample = "truncated")
}
\author{
Yves Croissant
}
