% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{topicsModel}
\alias{topicsModel}
\title{Topic modelling}
\usage{
topicsModel(
  dtm,
  num_topics = 20,
  num_top_words = 10,
  num_iterations = 1000,
  seed = 42,
  save_dir,
  load_dir = NULL
)
}
\arguments{
\item{dtm}{(R_obj) The document term matrix}

\item{num_topics}{(integer) The number of topics to be created}

\item{num_top_words}{(integer) The number of top words to be displayed}

\item{num_iterations}{(integer) The number of iterations to run the model}

\item{seed}{(integer) The seed to set for reproducibility}

\item{save_dir}{(string) The directory to save the model, if NULL, the model will not be saved}

\item{load_dir}{(string) The directory to load the model from, if NULL, the model will not be loaded}
}
\value{
A list of the model, the top terms, the labels, the coherence, and the prevalence
}
\description{
The function to create and train and an LDA model.
}
\examples{
\donttest{
# Create LDA Topic Model 
save_dir_temp <- tempfile()
dtm <- topicsDtm(
data = dep_wor_data$Depphrase, 
save_dir = save_dir_temp)

model <- topicsModel(
dtm = dtm, # output of topicsDtm()
num_topics = 20,
num_top_words = 10,
num_iterations = 1000,
seed = 42,
save_dir = save_dir_temp)
                   
# Load precomputed LDA Topic Model
model <- topicsModel(
load_dir = save_dir_temp,
seed = 42,
save_dir = save_dir_temp)
}
}
