% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{topicsPreds}
\alias{topicsPreds}
\title{Predict topic distributions}
\usage{
topicsPreds(
  model,
  data,
  num_iterations = 100,
  seed = 42,
  save_dir,
  load_dir = NULL
)
}
\arguments{
\item{model}{(list) The trained model}

\item{data}{(tibble) The new data}

\item{num_iterations}{(integer) The number of iterations to run the model}

\item{seed}{(integer) The seed to set for reproducibility}

\item{save_dir}{(string) The directory to save the model, if NULL, the predictions will not be saved}

\item{load_dir}{(string) The directory to load the model from, if NULL, the predictions will not be loaded}
}
\value{
A tibble of the predictions
}
\description{
The function to predict the topics of a new document with the trained model.
}
\examples{
\donttest{
# Predict topics for new data with the trained model
save_dir_temp <- tempfile()

dtm <- topicsDtm(
data = dep_wor_data$Depphrase, 
save_dir = save_dir_temp)

model <- topicsModel(dtm = dtm, # output of topicsDtm()
                     num_topics = 20,
                     num_top_words = 10,
                     num_iterations = 1000,
                     seed = 42,
                     save_dir = save_dir_temp)
                     
preds <- topicsPreds(
model = model, # output of topicsModel()
data = dep_wor_data$Depphrase, 
save_dir = save_dir_temp)
}
}
