% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{example_positions}
\alias{example_positions}
\title{Example Antigenic Mapping Data}
\format{
A data frame with 285 rows and 11 variables:
\describe{
\item{V1}{First dimension coordinate from 5D mapping}
\item{V2}{Second dimension coordinate from 5D mapping}
\item{V3}{Third dimension coordinate from 5D mapping}
\item{V4}{Fourth dimension coordinate from 5D mapping}
\item{V5}{Fifth dimension coordinate from 5D mapping}
\item{name}{Strain identifier}
\item{antigen}{Logical; TRUE if point represents an antigen}
\item{antiserum}{Logical; TRUE if point represents an antiserum}
\item{cluster}{Factor indicating antigenic cluster assignment (A/H3N2 1968-2003)}
\item{color}{Color assignment for visualization}
\item{year}{Year of strain isolation}
}
}
\source{
Smith et al., 2004
}
\usage{
example_positions
}
\description{
HI titers of Influenza antigens and antisera published in Smith et al., 2004 were
used to find the antigenic relationships and coordinates of the antigens.
It can be used for mapping. The data captures how different influenza virus strains
(antigens) react with antisera from infected individuals.
}
\keyword{datasets}
