% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_inverse}
\alias{torch_inverse}
\title{Inverse}
\usage{
torch_inverse(self)
}
\arguments{
\item{self}{(Tensor) the input tensor of size \eqn{(*, n, n)} where \code{*} is zero or more                    batch dimensions}
}
\description{
Inverse
}
\note{
\if{html}{\out{<div class="sourceCode">}}\preformatted{Irrespective of the original strides, the returned tensors will be
transposed, i.e. with strides like `input.contiguous().transpose(-2, -1).stride()`
}\if{html}{\out{</div>}}
}
\section{inverse(input, out=NULL) -> Tensor }{


Takes the inverse of the square matrix \code{input}. \code{input} can be batches
of 2D square tensors, in which case this function would return a tensor composed of
individual inverses.
}

\examples{
if (torch_is_installed()) {
\dontrun{
x = torch_rand(c(4, 4))
y = torch_inverse(x)
z = torch_mm(x, y)
z
torch_max(torch_abs(z - torch_eye(4))) # Max non-zero
# Batched inverse example
x = torch_randn(c(2, 3, 4, 4))
y = torch_inverse(x)
z = torch_matmul(x, y)
torch_max(torch_abs(z - torch_eye(4)$expand_as(x))) # Max non-zero
}
}
}
