% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapers.R
\name{torch_lu}
\alias{torch_lu}
\title{LU}
\usage{
torch_lu(A, pivot = TRUE, get_infos = FALSE, out = NULL)
}
\arguments{
\item{A}{(Tensor) the tensor to factor of size (\emph{, m, n)(},m,n)}

\item{pivot}{(bool, optional) – controls whether pivoting is done. Default: TRUE}

\item{get_infos}{(bool, optional) – if set to True, returns an info IntTensor. Default: FALSE}

\item{out}{(tuple, optional) – optional output tuple. If get_infos is True, then the elements
in the tuple are Tensor, IntTensor, and IntTensor. If get_infos is False, then the
elements in the tuple are Tensor, IntTensor. Default: NULL}
}
\description{
Computes the LU factorization of a matrix or batches of matrices A. Returns a
tuple containing the LU factorization and pivots of A. Pivoting is done if pivot
is set to True.
}
\examples{
if (torch_is_installed()) {

A <- torch_randn(c(2, 3, 3))
torch_lu(A)
}
}
