% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trace.R
\name{jit_save}
\alias{jit_save}
\title{Saves a \code{script_function} to a path}
\usage{
jit_save(obj, path, ...)
}
\arguments{
\item{obj}{An \code{script_function} to save}

\item{path}{The path to save the serialized function.}

\item{...}{currently unused}
}
\description{
Saves a \code{script_function} to a path
}
\examples{
if (torch_is_installed()) {
fn <- function(x) {
  torch_relu(x)
}

input <- torch_tensor(c(-1, 0, 1))
tr_fn <- jit_trace(fn, input)

tmp <- tempfile("tst", fileext = "pt")
jit_save(tr_fn, tmp)
}
}
