% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_masked_select}
\alias{torch_masked_select}
\title{Masked_select}
\usage{
torch_masked_select(self, mask)
}
\arguments{
\item{self}{(Tensor) the input tensor.}

\item{mask}{(BoolTensor) the tensor containing the binary mask to index with}
}
\description{
Masked_select
}
\note{
The returned tensor does \strong{not} use the same storage
as the original tensor
}
\section{masked_select(input, mask, out=NULL) -> Tensor }{


Returns a new 1-D tensor which indexes the \code{input} tensor according to
the boolean mask \code{mask} which is a \code{BoolTensor}.

The shapes of the \code{mask} tensor and the \code{input} tensor don't need
to match, but they must be broadcastable .
}

\examples{
if (torch_is_installed()) {

x = torch_randn(c(3, 4))
x
mask = x$ge(0.5)
mask
torch_masked_select(x, mask)
}
}
