% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transforms.R
\name{transform_mu_law_decoding}
\alias{transform_mu_law_decoding}
\title{Mu Law Decoding}
\usage{
transform_mu_law_decoding(quantization_channels = 256)
}
\arguments{
\item{quantization_channels}{(int, optional): Number of channels. (Default: \code{256})}
}
\value{
Tensor: The signal decoded.
}
\description{
Decode mu-law encoded signal.  For more info see the
\href{https://en.wikipedia.org/wiki/M-law_algorithm}{Wikipedia Entry}
}
\details{
This expects an input with values between 0 and quantization_channels - 1
and returns a signal scaled between -1 and 1.

forward param:
x_mu  (Tensor): A mu-law encoded signal which needs to be decoded.
}
