% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transforms-generics.R
\name{transform_affine}
\alias{transform_affine}
\title{Apply affine transformation on an image keeping image center invariant}
\usage{
transform_affine(
  img,
  angle,
  translate,
  scale,
  shear,
  resample = 0,
  fillcolor = NULL
)
}
\arguments{
\item{img}{A \code{magick-image}, \code{array} or \code{torch_tensor}.}

\item{angle}{(float or int): rotation angle value in degrees,
counter-clockwise.}

\item{translate}{(sequence of int) – horizontal and vertical translations
(post-rotation translation)}

\item{scale}{(float) – overall scale}

\item{shear}{(float or sequence) – shear angle value in degrees between -180 to 180,
clockwise direction. If a sequence is specified, the first value corresponds
to a shear parallel to the x-axis, while the second value corresponds to a
shear parallel to the y-axis.}

\item{resample}{(int, optional): An optional resampling filter. See interpolation
modes.}

\item{fillcolor}{(tuple or int): Optional fill color (Tuple for RGB Image and
int for grayscale) for the area outside the transform in the output image
(Pillow>=5.0.0). This option is not supported for Tensor input. Fill value
for the area outside the transform in the output image is always 0.}
}
\description{
Apply affine transformation on an image keeping image center invariant
}
\seealso{
Other transforms: 
\code{\link{transform_adjust_brightness}()},
\code{\link{transform_adjust_contrast}()},
\code{\link{transform_adjust_gamma}()},
\code{\link{transform_adjust_hue}()},
\code{\link{transform_adjust_saturation}()},
\code{\link{transform_center_crop}()},
\code{\link{transform_color_jitter}()},
\code{\link{transform_convert_image_dtype}()},
\code{\link{transform_crop}()},
\code{\link{transform_five_crop}()},
\code{\link{transform_grayscale}()},
\code{\link{transform_hflip}()},
\code{\link{transform_linear_transformation}()},
\code{\link{transform_normalize}()},
\code{\link{transform_pad}()},
\code{\link{transform_perspective}()},
\code{\link{transform_random_affine}()},
\code{\link{transform_random_apply}()},
\code{\link{transform_random_choice}()},
\code{\link{transform_random_crop}()},
\code{\link{transform_random_erasing}()},
\code{\link{transform_random_grayscale}()},
\code{\link{transform_random_horizontal_flip}()},
\code{\link{transform_random_order}()},
\code{\link{transform_random_perspective}()},
\code{\link{transform_random_resized_crop}()},
\code{\link{transform_random_rotation}()},
\code{\link{transform_random_vertical_flip}()},
\code{\link{transform_resize}()},
\code{\link{transform_resized_crop}()},
\code{\link{transform_rgb_to_grayscale}()},
\code{\link{transform_rotate}()},
\code{\link{transform_ten_crop}()},
\code{\link{transform_to_tensor}()},
\code{\link{transform_vflip}()}
}
\concept{transforms}
