% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/showMeta.R
\name{showMeta}
\alias{showMeta}
\title{Export Readable Meta-Data of Articles.}
\usage{
showMeta(
  meta,
  id = meta$id,
  cols = colnames(meta),
  file,
  fileEncoding = "UTF-8"
)
}
\arguments{
\item{meta}{A data.frame of meta-data as a result of a read-function.}

\item{id}{Character vector or matrix including article ids.}

\item{cols}{Character vector including the requested columns of meta.}

\item{file}{Character Filename for the export.}

\item{fileEncoding}{character string: declares file encoding. For more information see \code{\link[utils]{write.csv}}}
}
\value{
A list of the requested meta data. If file is set, writes a csv including the meta-data of the
requested meta data.
}
\description{
Exports requested meta-data of articles for given id's.
}
\examples{
meta <- data.frame(id=c("A", "B", "C", "D"),
title=c("Fishing", "Don't panic!", "Sir Ronald", "Berlin"),
date=c("1885-01-02", "1979-03-04", "1951-05-06", "1967-06-02"),
additionalVariable=1:4, stringsAsFactors=FALSE)

extractedMeta <- showMeta(meta=meta, cols = c("title", "date"))

}
\keyword{manip}
