% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_fips_cbsa.R
\docType{data}
\name{dict_cbsa}
\alias{dict_cbsa}
\title{List CBSA code of Metropolitan Statistical Area/Micropolitan Statistical Area}
\format{A data.table with 1882 rows and 12 variables:
\describe{
  \item{CBSA}{CBSA code}
  \item{CBSA_title}{CBSA title}
  \item{state_full}{full name of the state. A cbsa could include multiple states}
  \item{county}{county or county equivalent}
  \item{CSA}{code of the CSA to which the CBSA belongs}
  \item{CSA_title}{CSA title}
  \item{METDIV}{metro division code}
  \item{METDIV_title}{metro division title}
  \item{metro_micro}{is the CBSA a metropolitan or a micropolitan statistic area}
  \item{STATE}{FIPS of the state}
  \item{COUNTY}{FIPS of the county}
  \item{central_outlying}{is the counry a central or outlying county in the CBSA}
}}
\source{
\href{http://www.nber.org/data/cbsa-fips-county-crosswalk.html}{List of CBSA}
}
\usage{
data("dict_cbsa")
}
\description{
This dataset contains Metropolitan Statistical Area/Micropolitan
Statistical Area CBSA code and title, plus associated metrodivision, CSA, state,
and county code. Search for CBSA with function \code{\link{search_cbsa}}.
}
\keyword{datasets}
