% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_census_and_acs.R
\name{search_summarylevels}
\alias{search_summarylevels}
\title{Search Summary Levels}
\usage{
search_summarylevels(survey, years = NULL, keywords = NULL,
  view = TRUE)
}
\arguments{
\item{survey}{survey type, including "dec" (or "decennial"), "acs1" or "acs5".}

\item{years}{year or ending year of the survey, can be a single year such as
2010 or a vector like 2014:2016.}

\item{keywords}{keyword to search in code or description, in the form like
"abc def dsdfsa". Rows with all words are returned.}

\item{view}{display the search result with View if TRUE}
}
\value{
A data.table of searched results.
}
\description{
Search code or description of summary levels for summary_level
argument in  function \code{\link{read_decennial}},
\code{\link{read_acs1year}}, and \code{\link{read_acs5year}}.
}
\examples{
# Change view = TRUE (default) to View the returned data.
aaa = search_summarylevels("decennial", 2010, "block", view = FALSE)
bbb <- search_summarylevels("acs5", 2009:2010, "40", view = FALSE)

\dontrun{
  # view all summary levels
  search_summarylevels("decennial")
  search_summarylevels("acs1")
}

}
