% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tour-guided-anomaly.r
\name{guided_anomaly_tour}
\alias{guided_anomaly_tour}
\title{A guided anomaly tour path.}
\usage{
guided_anomaly_tour(
  index_f,
  d = 2,
  alpha = 0.5,
  cooling = 0.99,
  max.tries = 25,
  max.i = Inf,
  ellipse,
  ellc = NULL,
  ellmu = NULL,
  search_f = search_geodesic,
  ...
)
}
\arguments{
\item{index_f}{the section pursuit index function to optimise. The function
needs to take two arguments, the projected data, indexes of anomalies.}

\item{d}{target dimensionality}

\item{alpha}{the initial size of the search window, in radians}

\item{cooling}{the amount the size of the search window should be adjusted
by after each step}

\item{max.tries}{the maximum number of unsuccessful attempts to find
a better projection before giving up}

\item{max.i}{the maximum index value, stop search if a larger value is found}

\item{ellipse}{pxp variance-covariance matrix defining ellipse, default NULL.
Useful for comparing data with some hypothesized null.}

\item{ellc}{This can be considered the equivalent of a critical value, used to
scale the ellipse larger or smaller to capture more or fewer anomalies. Default 3.}

\item{ellmu}{This is the centre of the ellipse corresponding to the mean of the
normal population. Default vector of 0's}

\item{search_f}{the search strategy to use}

\item{...}{arguments sent to the search_f}
}
\description{
The guided anomaly tour is a variation of the guided tour that is
using an ellipse to determine anomalies on which to select target planes.
}
\details{
Usually, you will not call this function directly, but will pass it to
a method that works with tour paths like \code{\link{animate_xy}},
\code{\link{save_history}} or \code{\link{render}}.
}
\examples{
animate_xy(flea[, 1:6], guided_anomaly_tour(anomaly_index(),
  ellipse=cov(flea[,1:6])), ellipse=cov(flea[,1:6]), axes="off")
}
\seealso{
\code{\link{slice_index}} for an example of an index functions.
\code{\link{search_geodesic}}, \code{\link{search_better}},
  \code{\link{search_better_random}} for different search strategies
}
