% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_toxEval.R
\name{create_toxEval}
\alias{create_toxEval}
\title{Load and check toxEval data}
\usage{
create_toxEval(excel_file_path, ...)
}
\arguments{
\item{excel_file_path}{Path to Excel file that contains at least 3 sheets: Data, Chemicals, and Sites,
and could optionally contain Exclude and Benchmarks.}

\item{\dots}{data frames to override data within the original x list.}
}
\value{
The object returned from this function contains a list of between
three and five data frames. The minimum data frames returned are chem_data
(containing at least the columns: "CAS", "SiteID", "Value", "Sample Date"),
chem_info (containing at least the columns: "CAS", "Class"), and
chem_site (containing at least the columns: "SiteID", "Short Name". For the
Shiny app, "dec_lat" and "dec_lon" are also required). The optional data
frames are exclusions (containing at least the columns: "CAS" and "endPoint"),
and benchmarks (containing at least the columns: "CAS", "endPoint",
"ACC_value" and "chnm")
}
\description{
This function is used to load a data file for analysis in the form of a
single Excel file. The Excel file should include 3 mandatory sheets named
"Data", "Chemicals", and "Sites". Additionally there are 2 optional sheets:
"Exclude" and "Benchmarks". This function creates a data frame for each
sheet,  perform basic checks on the data to assure that required columns are
included for each sheet
}
\details{
Required columns in the Data sheet include "CAS", "SiteID", "Value", and
"Sample Date". The "Value" column includes concentration measurements in
units of \eqn{\mu}g/L. "Sample Date" can be either a date or date/time or an integer.
Additional columns may be included for user purposes, but will not be used in
toxEval.

Required columns in the Chemical sheet include "CAS", "Class". "CAS" values in
this sheet must exactly match corresponding "CAS" values in the Data sheet. The
"Class" designation allows  data to be grouped in a user-specified way. For
example, in a data set of multiple pesticides, it may be valuable to explore
differences and similarities to of insecticides, herbicides and fungicides.
Additional columns may be included for user purposes, but will not be used in
toxEval.

Required columns in the Sites sheet includes "SiteID", "Short Name", and for
the Shiny application "dec_lat","dec_lon". Values in the "SiteID" column in
this sheet exactly match corresponding values in the "SiteID" column in the
Data sheet. Additional columns may be included for user purposes, but will not
be used in toxEval.

When using the optional sheet Exclude, columns required include "CAS" and
"endPoint". These are used to exclude particular chemicals (via CAS),
ToxCast endpoints (via endPoint), or a unique chemical/endpoint combination.
Additional columns may be included for user purposes, but will not be used
in toxEval.

When using the optional sheet Benchmarks, columns required include "CAS",
"endPoint","ACC_value" and "chnm". This sheet is used to over-ride the
functions using endpoints from the ToxCast database, allowing the user
to import endpoint information from other sources. It could also be useful
for reproducing results in the future (for example, if after ToxCast updates,
analysis with an older version of ToxCast may be reproduced by including the
selected ToxCast endpoint database in this sheet. Additional columns may be included for user
purposes, but will not be used in toxEval.

For more information, see the "Prepare Data" vignette: \href{../doc/PrepareData.html}{\code{vignette("PrepareData", package = "toxEval")}}.

All remaining toxEval functions use data from via the list that is returned
from this function.
}
\examples{

path_to_tox <- system.file("extdata", package = "toxEval")
file_name <- "OWC_data_fromSup.xlsx"
excel_file_path <- file.path(path_to_tox, file_name)
tox_list <- create_toxEval(excel_file_path)
}
