% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rank_sites.R
\name{rank_sites_DT}
\alias{rank_sites_DT}
\alias{rank_sites}
\title{Rank sites by EAR}
\usage{
rank_sites_DT(
  chemical_summary,
  category = "Biological",
  mean_logic = FALSE,
  sum_logic = TRUE,
  hit_threshold = 0.1
)

rank_sites(
  chemical_summary,
  category,
  hit_threshold = 0.1,
  mean_logic = FALSE,
  sum_logic = TRUE
)
}
\arguments{
\item{chemical_summary}{Data frame from \code{\link{get_chemical_summary}}.}

\item{category}{Character. Either "Biological", "Chemical Class", or "Chemical".}

\item{mean_logic}{Logical.  \code{TRUE} displays the mean sample from each site,
\code{FALSE} displays the maximum sample from each site.}

\item{sum_logic}{Logical. \code{TRUE} sums the EARs in a specified grouping,
\code{FALSE} does not. \code{FALSE} may be better for traditional benchmarks as
opposed to ToxCast benchmarks.}

\item{hit_threshold}{Numeric threshold defining a "hit".}
}
\value{
data frame with one row per site, and the mas or mean EAR and frequency of
hits based on the category.
}
\description{
The \code{rank_sites_DT} (DT option) and \code{rank_sites} (data frame option) functions
create tables with one row per site. Columns represent the maximum or mean EAR
(depending on the mean_logic argument) for each category ("Chemical Class",
"Chemical", or "Biological") and the frequency of the maximum or mean EAR
exceeding a user specified hit_threshold.
}
\details{
The tables show slightly different results for a single site. Rather than multiple
columns for categories, there is now 1 row per category (since the site is known).
}
\examples{
# This is the example workflow:
path_to_tox <- system.file("extdata", package = "toxEval")
file_name <- "OWC_data_fromSup.xlsx"

full_path <- file.path(path_to_tox, file_name)

tox_list <- create_toxEval(full_path)

ACC <- get_ACC(tox_list$chem_info$CAS)
ACC <- remove_flags(ACC)

cleaned_ep <- clean_endPoint_info(end_point_info)
filtered_ep <- filter_groups(cleaned_ep)
chemical_summary <- get_chemical_summary(tox_list, ACC, filtered_ep)

stats_df <- rank_sites(chemical_summary, "Biological")

rank_sites_DT(chemical_summary, category = "Biological")
rank_sites_DT(chemical_summary, category = "Chemical Class")
rank_sites_DT(chemical_summary, category = "Chemical")

}
