% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trackeRdata_plot.R
\name{leafletRoute}
\alias{leafletRoute}
\title{Plot routes for training sessions.}
\usage{
leafletRoute(x, session = NULL, threshold = TRUE, ...)
}
\arguments{
\item{x}{A object of class \code{\link{trackeRdata}}.}

\item{session}{A numeric vector of the sessions to be plotted. Defaults to
all sessions.}

\item{threshold}{Logical. Should thresholds be applied?}

\item{...}{Additional arguments passed on to \code{\link{threshold}}.}
}
\description{
Plot the route ran/cycled during training on an interactive map.
Internet connection is required to download the background map.
Icons are by Maps Icons Collection \url{https://mapicons.mapsmarker.com}
}
\examples{
\dontrun{
data("runs", package = "trackeR")
leafletRoute(runs, session = 23:24)
}
}
