% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Generics.R, R/PlotWrapper.R,
%   R/accessor-methods.R, R/ggplotversions.R
\docType{methods}
\name{nObs}
\alias{nObs}
\alias{nObs,PlotFeatureSet-method}
\alias{nObs,trellis-method}
\alias{nObs,gTree-method}
\alias{nObs,ggplot-method}
\title{Accessor method for the number of observations (slot "nobs") of the plot object.}
\usage{
nObs(object)

\S4method{nObs}{PlotFeatureSet}(object)

\S4method{nObs}{trellis}(object)

\S4method{nObs}{gTree}(object)

\S4method{nObs}{PlotFeatureSet}(object)

\S4method{nObs}{ggplot}(object)
}
\arguments{
\item{object}{An object of class PlotFeatureSet, GGplotFeatureSet, TrellisFeatureSet, ggplot, or trellis.}
}
\value{
An integer representing the number of observations in the plotted data.
}
\description{
Number of observations plotted in a plot or associated PlotFeatureSet.
}
\examples{
library(ggplot2)
mt = datasets::mtcars
plt = qplot(mt$mpg, mt$cyl)
fs = makeFeatureSet(plt)
nObs(fs)
}
