% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.compare_trafo.R
\name{diagnostics.trafo_compare}
\alias{diagnostics.trafo_compare}
\title{Diagnostics for two differently transformed models}
\usage{
\method{diagnostics}{trafo_compare}(object, ...)
}
\arguments{
\item{object}{an object of type \code{trafo_compare}}

\item{...}{additional arguments that are not used in this method}
}
\value{
An object of class \code{diagnostics.trafo_compare}. The method 
\code{\link{print.diagnostics.trafo_compare}} can be used for this class.
}
\description{
Returns information about the applied transformations and selected 
diagnostics to check model assumptions. Two models are compared where
the dependent variable is transformed by different transformations.
}
\examples{
# Load data
data("cars", package = "datasets")

# Fit linear model
lm_cars <- lm(dist ~ speed, data = cars)

# Transform with Bickel-Doksum transformation
bd_trafo <- bickeldoksum(object = lm_cars, plotit = FALSE)

# Transform with Box-Cox transformation
bc_trafo <- boxcox(object = lm_cars, method = "skew", plotit = FALSE)

# Compare transformed models
compare <- trafo_compare(object = lm_cars, trafos = list(bd_trafo, bc_trafo))

# Get diagnostics
diagnostics(compare)
}
