% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/track_angle.R
\name{track_angle}
\alias{track_angle}
\title{Track angle}
\usage{
track_angle(x, y)
}
\arguments{
\item{x}{longitude}

\item{y}{latitude}
}
\value{
a numeric vector of the relative internal angle between sequential locations
in degrees, see Details
}
\description{
Calculate internal track angle on longitude, latitude input vectors.
}
\details{
By convention the first and last values are set to \code{NA} missing value, because the angle
applies to the location between each previous and next location.

To use this on multiple track ids, use a grouped data frame with tidyverse code like
\code{data \%>\% group_by(id) \%>\% mutate(angle = track_angle(lon, lat))}.

The maximum possible value is 180 and the minimum is 0.
}
\examples{
track_angle(trips0$x, trips0$y)[1:10]

## maximum value
track_angle(c(0, 0, 0), c(0, 1, 2))
## minimum value
track_angle(c(0, 0, 0), c(0, 1, 0))
}
