% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/track_bearing_to.R
\name{track_bearing_to}
\alias{track_bearing_to}
\title{Track bearing to location/s}
\usage{
track_bearing_to(x, y, to_x, to_y)
}
\arguments{
\item{x}{longitude}

\item{y}{latitude}

\item{to_x}{longitude vector of \emph{to} location/s}

\item{to_y}{latitude vector of \emph{to} locations/s}
}
\value{
a numeric vector of absolute bearing-to in degrees, see Details
}
\description{
Calculate geodesic bearing to a location or locations based on longitude, latitude (from)
input vectors and longitude, latitude (to) input vectors. The \emph{to} values may be a
single value or individual to each \emph{from} location.
}
\details{
No missing values are required as padding, but input data with \code{NA}s will incur an
\code{NA} in the output.

To use this on multiple track ids, use a grouped data frame with tidyverse code like
\code{data \%>\% group_by(id) \%>\% mutate(bearing_to = track_bearing_to(lon, lat, to_lon, to_lat))}.

Absolute bearing is relative to North (0), and proceeds clockwise positive and anti-clockwise
negative \code{N = 0, E = 90, S = +/-180, W = -90}.

There is no \code{NA} padding in the output value (though missing values in the input will be mirrored
in the output).
}
\examples{
track_bearing_to(trips0$x, trips0$y, to_x = 147, to_y = -42)[1:10]
# N E S W
track_bearing_to(0,0, c(0, 10, 0, -10), c(5, 0, -5, 0))

# maximum and minimum value are the same direction (due south)
track_bearing(c(0, -0.00001), c(0, -1))
track_bearing(c(0,  0.00001), c(0, -1))

# the absolute minimum is north
track_bearing(c(0, 0), c(0, 1))
}
