% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thesaurus.R
\name{as.trait}
\alias{as.trait}
\title{Create a trait definition}
\usage{
as.trait(
  trait,
  identifier = NA,
  broaderTerm = NA,
  narrowerTerm = NA,
  relatedTerm = NA,
  valueType = NA,
  expectedUnit = NA,
  factorLevels = NA,
  replaceFactorLevels = NA,
  maxAllowedValue = NA,
  minAllowedValue = NA,
  traitDescription = NA,
  comments = NA,
  source = NA,
  version = NA,
  author = NA,
  ...
)
}
\arguments{
\item{trait}{A character string, providing an intuitive, human-readable trait
name.}

\item{identifier}{Unique identifier for the trait, ideally unique and stable
URI which identify the source of the trait definition.}

\item{broaderTerm}{One or several terms that enclose the trait definition.}

\item{narrowerTerm}{One or several terms that are enclosed by the trait
definition.}

\item{relatedTerm}{One or several terms that are related to this term
(ideally given as URI).}

\item{valueType}{the type of trait values. Possible entries are 'numeric',
'integer', 'categorical', 'logical', or 'character'.}

\item{expectedUnit}{the unit expected for measurement entries.}

\item{factorLevels}{A comma separated list of terms comprising the
constrained vocabulary for categorical traits or ordinal binary traits.}

\item{replaceFactorLevels}{A list or vector containing synonymous factor
levels to be mapped onto the target factor levels provided in
'factorLevels'. Names of the vector or list entries will be superimposed by
entries in 'factorLevels'.}

\item{maxAllowedValue}{An upper boundary for accepted numerical values.}

\item{minAllowedValue}{A lower boundary for accepted numerical values.}

\item{traitDescription}{A short, unambiguous definition of the trait. May
refer to a method of measurement.}

\item{comments}{Details and Examples for clarification of the trait
definition.}

\item{source}{A character string providing a full bibliographic reference to
the trait definition (giving title, author, year and publication).}

\item{version}{A character string containing the version number of the
referenced definition (e.g. "v1.2"), if applicable.}

\item{author}{A character string or object of class 'person' (as created by
\code{as.person()}) attributing the author(s) of the trait definition.}

\item{...}{other arguments, passed on to print function.}
}
\description{
Creating an object containing a standardised trait definition according to
the Ecological Traitdata Standard. Parameters correspond to the definition at
\url{https://ecologicaltraitdata.github.io/ETS/#terms-for-trait-definitions}.
}
\examples{

body_length <- as.trait("body_length", expectedUnit = "mm", valueType = "numeric",
  identifier = "http://t-sita.cesab.org/BETSI_vizInfo.jsp?trait=Body_length",
  traitDescription = "The known longest dimension of the physical structure of organisms",
  relationSource = "Maggenti and Maggenti, 2005",
  broaderTerm = "http://t-sita.cesab.org/BETSI_vizInfo.jsp?trait=Body_dimension"
  )

}
