% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betydb.R
\name{betydb_query}
\alias{betydb_query}
\alias{betydb_search}
\title{Query a BETY table}
\usage{
betydb_query(..., table = "search", key = NULL, api_version = NULL,
  betyurl = NULL, user = NULL, pwd = NULL)

betydb_search(query = "Maple SLA", ..., include_unchecked = NULL)
}
\arguments{
\item{...}{(named character) Columns to query, as key="value" pairs. Note that betydb_query passes these along to BETY with no check whether the requested keys exist in the specified table.}

\item{table}{(character) The name of the database table to query, or "search" (the default) for the traits and yields view}

\item{key}{(character) An API key. Use this or user/pwd combo.
Save in your \code{.Rprofile} file as \code{options(betydb_key = "your40digitkey")}. Optional}

\item{api_version}{(character) Which version of the BETY API should we query? One of "v0" or "beta".
Default is \code{options("betydb_api_version")} if set, otherwise  "v0".}

\item{betyurl}{(string) url to target instance of betydb.
Default is \code{options("betydb_url")} if set, otherwise "https:/www.betydb.org/"}

\item{user, pwd}{(character) A user name and password. Use a user/pwd combo or an API key.
Save in your \code{.Rprofile} file as \code{options(betydb_user = "yournamehere")} and \code{options(betydb_pwd = "yourpasswordhere")}. Optional}

\item{query}{(character) A string containing one or more words to be queried across all columns of the "search" table.}

\item{include_unchecked}{(logical) Include results that have not been quality checked? Applies only to tables with a "checked" column: "search", "traits", "yields". Default is to exclude unchecked values.}
}
\value{
A data.frame with attributes containing request metadata, or NULL if the query produced no results
}
\description{
Query a BETY table
}
\details{
Use betydb_query to retrieve records from a table that match on all the column filters specified in '...'.
If no filters are specified, retrieves the whole table. In API versions that support it (i.e. not in v0), filter strings beginning with "~" are treated as regular expressions.
}
\examples{
\dontrun{
# literal vs regular expression vs anchored regular expression:
betydb_query(units = "Mg", table = "variables")
# NULL
betydb_query(units = "Mg/ha", table = "variables") \%>\% select(name) \%>\% c()
# $name
# [1] "a_biomass"                  "root_live_biomass"
# [3] "leaf_dead_biomass_in_Mg_ha" "SDM"

betydb_query(genus = "Miscanthus", table = "species") \%>\% nrow()
# [1] 10
(betydb_query(genus = "~misc", table = "species", api_version = "beta")
 \%>\% select(genus)
 \%>\% unique() \%>\% c())
# $genus
# [1] "Platymiscium" "Miscanthus"   "Dermiscellum"

(betydb_query(genus = "~^misc", table = "species", api_version = "beta")
 \%>\% select(genus)
 \%>\% unique() \%>\% c())
# $genus
# [1] "Miscanthus"
}

}
