% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convenience.R
\name{TrajConvertTime}
\alias{TrajConvertTime}
\title{Converts a delimited time string to a numeric value}
\usage{
TrajConvertTime(time, sep = ":", factors = c(60 * 60, 60, 1, 0.001))
}
\arguments{
\item{time}{A character string containing the time value to be converted.}

\item{sep}{Field separator.}

\item{factors}{Vector of numeric factors to be applied to each field, in the
order they occur within `time`. The default assumes 4 fields containing
numeric hours, minutes, seconds and milliseconds.}
}
\value{
`time` converted to a numeric value.
}
\description{
Time values may be imported in a format which is not immediately usable by
`trajr`. This function converts times that are specified as a number of
delimited fields to a single numeric value. The default parameter values
handle a value with 4 colon-separated values, which are hours, minutes,
seconds and milliseconds, eg: "0:01:04:108" represents 1 minute, 4 seconds
and 108 milliseconds, or 64.108 seconds.
}
\details{
Note that the base R strptime can be used to convert time values in more
complex date/time formats, but it does not handle millisecond fields.
}
\examples{
time <- c("0:00:00:029", "0:01:00:216", "0:02:01:062", "1:00:02:195", "1:06:03:949", "1:42:04:087")
seconds <- TrajConvertTime(time)

}
\seealso{
\code{\link[base]{strptime}}
}
