% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/speed.R
\name{plot.TrajSpeedIntervals}
\alias{plot.TrajSpeedIntervals}
\title{Plot method for trajectory speed intervals}
\usage{
\method{plot}{TrajSpeedIntervals}(x, slowerThanColour = "red",
  fasterThanColour = "green", highlightColor = "#0000FF1E",
  xlab = sprintf("Time (\%s)", TrajGetTimeUnits(attr(x, "trajectory"))),
  ylab = sprintf("Speed (\%s/\%s)", TrajGetUnits(attr(x, "trajectory")),
  TrajGetTimeUnits(attr(x, "trajectory"))), ...)
}
\arguments{
\item{x}{An object of class "SpeedIntervals", as created by
\code{\link{TrajSpeedIntervals}}.}

\item{slowerThanColour, fasterThanColour}{The colour of the horizontal line
plotted at the "slower than" or "faster than" speed. Specify \code{NULL} to
prevent the line from being plotted.}

\item{highlightColor}{Colour of the highlight rectangles.}

\item{xlab, ylab}{plotting parameters with useful defaults.}

\item{...}{Additional arguments are passed to \code{\link[graphics]{plot}}.}
}
\description{
Plots speed over time, with intervals of fast and/or slow speed highlighted.
}
\seealso{
\code{\link{TrajSpeedIntervals}}
}
