% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.tramME}
\alias{predict.tramME}
\title{Predict method for tramME objects}
\usage{
\method{predict}{tramME}(
  object,
  newdata = model.frame(object),
  ranef = NULL,
  fix_smooth = TRUE,
  type = c("lp", "trafo", "distribution", "survivor", "density", "logdensity", "hazard",
    "loghazard", "cumhazard", "odds", "logodds", "quantile"),
  ...
)
}
\arguments{
\item{object}{A \code{tramME} object.}

\item{newdata}{an optional data frame of observations}

\item{ranef}{Random effects it can be a \code{ranef.tramME} object, a named list,
an unnamed list, \code{NULL} or the word "zero". See Details.}

\item{fix_smooth}{If \code{FALSE}, the random effects coefficients of the smooth
terms are refitted to \code{newdata}. It's probably not what you want to do.}

\item{type}{The scale on which the predictions are evaluated:
\itemize{
  \item lp: Linear predictor (Xb + Zg). For more information, see Details.
  \item trafo: The prediction evaluated on the scale of the
    transformation function.
  \item distribution: The prediction evaluated on the scale of the
    conditional CDF.
  \item survivor: The prediction evaluated on the scale of the
    (conditional) survivor function.
  \item density, logdensity: The prediction evaluated on the scale of
    the conditional (log-)PDF.
  \item hazard, loghazard, cumhazard: The prediction evaluated on the
    hazard/log-hazard/cumulative hazard scale.
  \item odds, logodds: The prediction evaluated on the (log-)odds scale.
  \item quantile: Return the quantiles of the conditional outcome distribution
    corresponding to \code{newdata}. For more information, see Details.
}}

\item{...}{Additional arguments, passed to \code{\link[mlt]{predict.mlt}}.}
}
\value{
A numeric vector/matrix of the predicted values (depending on the inputs)
  or a \code{response} object, when the some of the requested conditonal quantiles
  fall outside of the support of the response distribution specified when the model
  was set up (only can occur with \code{type = "quantile"}).
}
\description{
Evaluates the _conditional_ distribution implied by a tramME model, given by a
set of covariates and random effects on a selected scale.
}
\details{
When \code{newdata} contains values of the response variable, prediction is only
done for those values. In this case, if random effects vector (\code{ranef}) is not
supplied by the user, the function predicts the random effects from the model
using \code{newdata}.

When no response values are supplied in \code{newdata}, the prediction is done
on a grid of values for each line of the dataset (see \code{\link[mlt]{predict.mlt}}
for information on how to control the setup of this grid).
In this case, the user has to specify the vector of random effects to avoid ambiguities.

The linear predictor (\code{type = "lp"}) equals to the shift terms plus the random
effects terms _without the baseline transfromation function_.

The linear predictor (\code{type = "lp"}) and the conditional quantile function
(\code{type = "quantile"}) are special in that they do not return results evaluated
on a grid, even when the response variable in \code{newdata} is missing. The probabilities
for the evaluation of the quantile function can be supplied with the \code{prob} argument
of \code{\link[mlt]{predict.mlt}}.

In the case of \code{type = "quantile"}, when the some of the requested conditonal
quantiles fall outside of the support of the response distribution
(specified when the model was set up), the inversion of the CDF cannot be done exactly
and \code{tramME} returns censored values.

\code{ranef} can be different objects based on what we want to calculate and
what the other inputs are. If \code{ranef} is a \code{ranef.tramME}, we assume
that it contains the full set of random effects, but not the penalized coefficients
of the smooth terms. In this case \code{fix_smooth} must be \code{TRUE}. If
\code{ranef} is a named vector, we are fixing the supplied random effects (and
penalized coefficients) and predict the rest from \code{newdata} (\code{fix_smooth}
may also be used in this case). In this case, the random effects are identified
with the same naming convention as in \code{object$param$gamma}.

If \code{ranef} is an unnamed vector, the function expects the
full set of necessary random effects (with or without penalized coefficients, depending
on \code{fix_smooth}). If \code{ranef = NULL} (the default), all random effects and
optionally penalized parameters (although this is not recommended) are predicted from
\code{newdata}. Finally, if \code{ranef} is equal to "zero", a vector of zeros with the
right size is used.
}
\examples{
data("sleepstudy", package = "lme4")
fit <- BoxCoxME(Reaction ~ Days + (Days | Subject), data = sleepstudy)
predict(fit, type = "trafo") ## evaluate on the transformation function scale
nd <- sleepstudy
nd$Reaction <- NULL
pr <- predict(fit, newdata = nd, ranef = ranef(fit), type = "distribution",
              K = 100)
}
