% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/xpssComputeStrings.R
\name{computeChar_rpad}
\alias{computeChar_rpad}
\title{Expand strings on the right}
\usage{
computeChar_rpad (x, length = NULL, fill = NULL)
}
\arguments{
\item{x}{atomic character or character vector.}

\item{length}{numeric. Number of characters x is to be filled on the right.}

\item{fill}{optional. String which x should be filled with.}
}
\value{
String, right-padded by length \code{length}.
}
\description{
Helper Function for xpssCompute. R Implementation of the SPSS \code{CHAR.RPAD} Function.
}
\details{
The value of length represents the number of characters and must be a positive integer. If the optional argument \code{fill} is not specified, \code{x} is padded with blank spaces.
}
\examples{
xpssCompute(x="My Friend", fun="computeChar_rpad", length=15)
xpssCompute(x="My Friend", fun="computeChar_rpad", length=15, fill = "Hello")
}
\author{
Bastian Wiessner
}
\seealso{
\code{\link{paste0}}
}
\keyword{internal}

