% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/xpssVariableLabels.R
\name{xpssVariableLabels}
\alias{xpssVariableLabels}
\title{Modifies variable labels}
\usage{
xpssVariableLabels(x, variables = NULL, labels = NULL)
}
\arguments{
\item{x}{a (non-empty) data.frame or input data of class "xpssFrame".}

\item{variables}{atomic character or character vector with the names of the variable(s).}

\item{labels}{atomic character of character vector with labels for the specified variables in variables. The labels are associated in order of appearence
of the variables.}
}
\value{
Input Data with modified attribute variable label.
}
\description{
R implementation of the SPSS \code{VARIABLE LABEL} function. Changing the label of a variable. In the structure of xpss-data the variable label is an attribute of each variable.
}
\examples{
data(fromXPSS)

daten <- xpssVariableLabels(fromXPSS, c("V4", "V7_1"), c("Label1", "Label2"))
}
\author{
Andreas Wygrabek
}
\seealso{
\code{\link{attributes}} \code{\link{attr}} \code{\link{xpssValueLabels}}
}

