% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans.R
\name{trans}
\alias{trans}
\title{Translate strings}
\usage{
trans(.key, ..., .n = NULL)
}
\arguments{
\item{.key}{\code{character()}\cr
Keys to the translation map (accepts vectors of strings). Keys should not
contain dots, unless it's a compound key (where dots separate parts of
path to the key, e.g. \code{"submit_form.buttons.reset"}).}

\item{...}{\code{character(1)}\cr
Named strings to substitute into translation; they replace substrings of the
form \code{"{var}"} (\code{var} being a name of a string). Avoid names starting with
dots to avoid incompatibility issues with future versions of this package.}

\item{.n}{\code{integer(1)}\cr
Count for translating value-dependent messages, e.g. "n file(s)".}
}
\value{
A string vector of the same length as \code{.key}, each element being a
translated string.
}
\description{
This function finds a translation for given keys in translation
JSON files. If none found, a bare key is returned and a warning raised.
Translation language is controlled by \code{\link{trans_locale}()} function.

Translation strings may contain \code{{var}} chunks. These are replaced in the
final string by respective strings passed to \code{...}.

If a translation depends on a count, a \code{.n} parameter allows the user to
select an appropriate translation form. Count interpretation is defined
within translation JSONs for each language separately under \verb{$.config.plural}
path. Integer returned by this interpretation function is used as index for
extracting the correct translation from an array.

Thanks to the implementation strategy, it is possible to create recursive
translations (i.e. translations whose smaller chunks are translations
themselves). This makes it possible to translate statements like
"Found n file(s) in m directory/ies" by translating "files" and "directories"
chunks first. In this case an appropriate translation entry would look like:
"Found {trans("file", .n = n_files)} in {trans("directory", .n = n_dirs)}".
Braces evaluate the content inside as R code.
}
\examples{
trans_path(system.file("examples", package = "translated"))

trans("title")
trans("btn_insert", number = "five")
# Non-character values are coerced to strings
trans("btn_insert", number = 5)

# Missing entries raise a warning and return the key
trans("missing_entry")

}
