% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibCurve.R
\name{calibCurve}
\alias{calibCurve}
\title{Calculates regression curve for external standard calibration.}
\usage{
calibCurve(curve, order = 1, badpoint = NULL, intercept = TRUE, plot = TRUE)
}
\arguments{
\item{curve}{Data frame of numeric vectors named 'Conc' and 'Signal'
containing the concentrations and the signals,
respectively.}

\item{order}{Regression curve order. 1 for linear (default) and 2 for
quadratic.}

\item{badpoint}{Numeric vector with the points to be ignored in the
regresion. This allows the easy elimination of outliers
without losing the stored measurement information.}

\item{intercept}{Logical. If \code{TRUE}, the default, the intercept is
calculated normally instead of being forced to 0.}

\item{plot}{Logical. If \code{TRUE}, the default, the calibration data
is plotted.}
}
\value{
Model of the calibration curve.
}
\description{
Polinomial regression curves for external standard calibration are
calculated to later convert signals into concentration values.
}
\details{
A linear method (i.e \code{lm()}) is applied to obtain the
regression curve.
}
\examples{
  data(curvelithium)
  model1 <- calibCurve(curve = curvelithium, order = 1)
  model2 <- calibCurve(curve = curvelithium, order = 2)
  summary(model1)
  summary(model2)
}
\seealso{
\code{\link{calibPlane}} when using more than one explanatory
  variable.
}
\author{
Cristhian Paredes, \email{craparedesca@unal.edu.co}

Eduardo Rodriguez de San Miguel, \email{erdsmg@unam.mx}
}
