% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cyclesPlot.R
\name{cyclesPlot}
\alias{cyclesPlot}
\title{Plots transport profiles for processes involving several cycles}
\usage{
cyclesPlot(trans, xlab = "Time (h)", ylab = expression(Phi), xlim = NULL,
  ylim = NULL, xbreaks = NULL, ybreaks = NULL, size = 1.8,
  legend = FALSE)
}
\arguments{
\item{trans}{List containing the (ordered) transport data of each cycle.
Each data frame must be generated using
\code{\link{conc2frac}}.}

\item{xlab}{Label to be used for x axis. Text and expression allowed.}

\item{ylab}{Label to be used for y axis. Text and expression allowed.}

\item{xlim}{Numeric vector of limits for X-axis.}

\item{ylim}{Numeric vector of limits for X-axis.}

\item{xbreaks}{Numeric vector of x-axis breaks.}

\item{ybreaks}{Numeric vector of x-axis breaks.}

\item{size}{Size used for points in the plot.}

\item{legend}{Logical. If \code{FALSE}, the default, the legend is not
included.}
}
\value{
Plot of the transport process carried in several cycles
}
\description{
Given the data (data frames) of a transport process that was carried
in several cycles (e.g. membrane reuse or metal concentration studies),
plots the transport profiles like in a continuous experiment indicating
the end of each cycle
}
\details{
If a concentration experiment has been made through the cycles, it is
recommended the y-axis to be in concentration scale instead of fractions.
To get the transport data frame in concentration units use
\code{conc2frac(..., normalize = FALSE)}. For more details see
\code{\link{conc2frac}}.

Most \code{transmem} graphical representations are made using the package
\code{ggplot2} so the function returns a ggplot2 object that can be
assigned to a variable for further modification.
}
\references{
Wickham H (2016). ggplot2: Elegant Graphics for Data Analysis.
Springer-Verlag New York. ISBN 978-3-319-24277-4,
\url{https://ggplot2.tidyverse.org}.
}
\author{
Cristhian Paredes, \email{craparedesca@unal.edu.co}

Eduardo Rodriguez de San Miguel, \email{erdsmg@unam.mx}
}
