% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seqic_8.R
\name{seqic_indicator_8}
\alias{seqic_indicator_8}
\title{SEQIC Indicator 8 - Survival by Risk Group}
\usage{
seqic_indicator_8(
  data,
  level,
  included_levels = c("I", "II", "III", "IV"),
  unique_incident_id,
  mortality_indicator,
  risk_group,
  groups = NULL,
  calculate_ci = NULL,
  ...
)
}
\arguments{
\item{data}{A data frame containing trauma incident records.}

\item{level}{Column indicating the trauma center designation level (e.g., I,
II, III, IV).}

\item{included_levels}{Character vector indicating what facility levels to
include in the analysis.  Defaults to \code{c("I", "II", "III", "IV")}.}

\item{unique_incident_id}{Unique identifier for each record.}

\item{mortality_indicator}{A logical, character, or factor variable
indicating whether the patient died at the trauma center. Accepts values
like \code{TRUE}/\code{FALSE} or \code{"Yes"}/\code{"No"}.}

\item{risk_group}{A character or factor column indicating the patient's risk
group (e.g., "High", "Moderate", "Low"). See risk definitions below.}

\item{groups}{Additional columns passed as a vector of strings to
\code{dplyr::summarize()} via the \code{.by} argument for grouped summaries. Defaults
to \code{NULL}.}

\item{calculate_ci}{If \code{NULL}, 95\% confidence intervals will not be
calculated for the performance estimates.  Otherwise, options of "wilson"
or "clopper-pearson" can be supplied to utilize the corresponding methods
to calculate the confidence intervals for the proportions. Defaults to
\code{NULL}.}

\item{...}{
  Arguments passed on to \code{\link[nemsqar:nemsqa_binomial_confint]{nemsqar::nemsqa_binomial_confint}}
  \describe{
    \item{\code{conf.level}}{Numeric value between 0 and 1 indicating the confidence
level. Defaults to 0.95 (95\% confidence interval).}
    \item{\code{correct}}{Logical, indicating whether to apply continuity correction for
Wilson intervals. Defaults to \code{TRUE}.}
  }}
}
\value{
A named list with two tibbles:

\code{overall}: A tibble summarizing overall mortality among trauma patients,
grouped by the variables specified in \code{groups}. Columns include:

\itemize{
\item \code{numerator_8_all} (number of survivors),
\item \code{denominator_8_all} (total number
of unique trauma incidents),
\item \code{seqic_8_all} (survival proportion), and optionally
\item \code{lower_ci_8},
\item \code{upper_ci_8} (confidence interval bounds if \code{calculate_ci} is
specified).
}

\code{risk_group}: A tibble summarizing mortality stratified by risk group and any
additional grouping variables. Columns include:

\itemize{
\item \code{risk_group} (used for stratification),
\item \code{numerator_8_risk} (survivors per group),
\item \code{denominator_8_risk} (total incidents per group),
\item \code{seqic_8_risk} (survival proportion per group), and optionally
\item \code{lower_ci_8_risk},
\item \code{upper_ci_8_risk} (confidence interval bounds if \code{calculate_ci} is
specified).
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Calculates the proportion of patients who survived based on risk groups
existing in the data among trauma patients transported to Level I–IV trauma
centers.
}
\details{
\itemize{
\item Filters the dataset to include only trauma center levels I through
IV.
\item Deduplicates the dataset using \code{unique_incident_id} to ensure one
record per incident.
\item Accepts a mortality indicator that may be logical, character, or
factor, and identifies survivors as those with values of \code{FALSE} or \code{"No"}.
\item Requires a predefined \code{risk_group} variable representing categories
such as "Low", "Moderate", or "High" risk.
\item Calculates overall survival proportions and survival proportions
stratified by risk group.
\item Optionally includes 95\% confidence intervals using binomial methods
if \code{calculate_ci} is specified.
}
}
\note{
This function calculates survival outcomes for patients transported
to trauma centers, stratified by risk of mortality. Risk groups—low,
moderate, and high— are defined by the Iowa System Evaluation and Quality
Improvement Committee (SEQIC) as described below. Users may also apply
alternative risk stratification methods if preferred.

\itemize{
\item Abnormal Physiology Criteria: GCS 3–5; Respirations <5 or >30 per
minute; Systolic BP <60 mm Hg
\item High Risk: Probability of Survival < 0.2; ISS > 41; ISS > 24 with
abnormal physiology
\item Moderate Risk: Probability of Survival 0.2–0.5; ISS 16–41
\item Low Risk: Probability of Survival > 0.5; ISS < 16; Normal physiology
}

Users must ensure appropriate column names are passed and data is
pre-processed to include the necessary fields without missing critical
identifiers or timestamps.
}
\examples{
# Packages
library(dplyr)
library(traumar)

# Simulated dataset for SEQIC Indicator 8
test_data <- tibble::tibble(
  id = as.character(1:12),
  trauma_level = c("I", "II", "III", "IV", "V", "II", "I", "III", "IV", "II",
  "I", "III"),
  mortality = c(FALSE, "No", TRUE, "Yes", FALSE, TRUE, "No", FALSE, "Yes",
  FALSE, TRUE, "No"),
  risk = c("High", "High", "Moderate", "Moderate", "Low", "Low", "High",
  "Moderate", "Low", "Moderate", "High", "Low")
)

# Run indicator 8 function
traumar::seqic_indicator_8(
  data = test_data,
  level = trauma_level,
  unique_incident_id = id,
  mortality_indicator = mortality,
  risk_group = risk
)

}
\author{
Nicolas Foss, Ed.D., MS
}
